# -*- coding": "utf-8 -*-
import webbrowser
import requests, json

from PythonPlugin import PythonPlugin

class Weather (PythonPlugin):

    def Query (self, query) :
        res = requests.get("http://api.map.baidu.com/telematics/v3/weather?location=" + query + "&ak=8yoeZq9BzQGxKQMvpUyKNZuZ&output=json")

        data = json.loads(res.content.decode())['results'][0]
        index = data['index']
        weather = data['weather_data']
        results = []
        
        count = 0
        for i in weather :
            if count == 0:
                descript = index[0]
                results.append({
                "Title": "[今日]  %s     %s      %s" % (i['weather'],i['temperature'],i['wind']),
                "SubTitle": "%s" % descript['des'],
                "IconPath": "Images/app.png"
                })
            else:
                results.append({
                    "Title": "[%s]  %s     %s      %s" % (i['date'],i['weather'] ,i['temperature'],i['wind']),
                    "SubTitle": "",
                    "IconPath": "Images/app.png"
                })
            count = count + 1

        return results

if __name__ == "__main__" :
    Weather()